@extends('layouts.setup')
@section('content')
<div class="d-flex justify-content-center">
	<div class="card mt-4 text-dark wizard-form border-0 shadow-custom text-sm">
		<div class="card-header border-grey">
			<h3 class="card-title float-none text-center">
				Server Requirements
			</h3>
		</div>
		<div class="card-body">
		  @if(empty($requirements))
			<div class="text-center">  
			  <p class="alert alert-success" role="alert">
				The server meets all the necessary criteria. You can safely proceed to the next step in the process.
			  </p>
			  <a href="{{ route('setup.database', 'create') }}" class="btn btn-primary">Proceed</a>
			</div>
		  @else
			<p class="alert alert-danger" role="alert">
				Ensure all requirements are met before proceeding to the next step.
			</p>
			@foreach($requirements as $r)
			   <p><i class="fa fa-info-circle"></i> {{ $r }}</p>
			@endforeach	
		  @endif
		</div>
	</div>
</div>
@endsection